<?php

include('../config.php');
include('../util.php');

$l = get_conn();

function makeListParms($offset, $sortby, $dir, $displaysize, $searchdata, $moreParams) {
	$searchdata = urlencode($searchdata);
	$mp = '';
	foreach ($moreParams as $k => $v) {
		$mp .= urlencode($k)."=".urlencode($v)."&";
	}
	return $mp."searchdata=$searchdata&offset=$offset&sortby=$sortby&dir=$dir&displaysize=$displaysize";
}

// Additional Params
$v = $_SERVER['REQUEST_METHOD']=='POST'?$_POST:$_GET;
$moreParams = array();


$detailurl = 'pollDetail.php';
$detailurlsepchar = preg_match('/\?/',$detailurl)?'&':'?';

if ($_POST['add']) {
	header('Status: 302 Moved');
	header('Location: '."$detailurl$detailurlsepchar"."action=addblank");
	exit();
}

if ($_POST['update']) {
	$deleteids = $_POST['deleteids'];
	if (!$deleteids) $deleteids = array();
	foreach ($deleteids as $did) {
		$o = find_poll_id($did, $l);
		$o->delete();
	}
	header('Status: 302 Moved');
	header('Location: '.$SCRIPT_NAME.'?'.makeListParms($_POST['offset'], $_POST['sortby'], $_POST['dir'], $_POST['displaysize'], stripslashes($_POST['searchdata']), $moreParams));
	exit();
}

if ($_SERVER['REQUEST_METHOD']=='POST') {
	header('Status: 302 Moved');
	header('Location: '.$SCRIPT_NAME.'?'.makeListParms($_POST['offset'], $_POST['sortby'], $_POST['dir'], $_POST['displaysize'], stripslashes($_POST['searchdata']), $moreParams));
	exit();
}

if (!isset($_GET['sortby'])) $sortby = 'id'; else $sortby = $_GET['sortby'];
if (!isset($_GET['dir'])) $dir = 'asc';
if (!isset($_GET['offset'])) $offset = 0;
if (!isset($_GET['displaysize'])) $displaysize = 20;
$searchdata = stripslashes($_GET['searchdata']);

if (strlen($searchdata) < 1) {
	// unrestrained search
	$oseq = find_poll_all($sortby.' '.$dir, $offset, $displaysize+1, $l);
} else {
	$oseq = find_poll_title($searchdata, $sortby.' '.$dir, $offset, $displaysize+1, $l);
}

$o = $oseq->getNextElement();
if (!$o) {
	if ($offset>0) {
		header('Status: 302 Moved');
		header('Location: '.$SCRIPT_NAME.'?'.makeListParms(0, $sortby, $dir, $displaysize, stripslashes($searchdata), $moreParams));
		exit();
	}
} else {
	$oseq->pushBackElement($o);
}


?>
<html>
<head>
<title>Polls</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body bgcolor="#FFFFFF" text="#000000">
CBCM Newsletter Poll Administration 
<form name="<?=$objectname?>form" method="post" action="<?=$SCRIPT_NAME?>">
  <p>Search: 
    <input type="text" name="searchdata" value="<?=$_GET["searchdata"]?>">
    <input type="submit" name="go" value="Go">
  </p>
  <table cellpadding="0" cellspacing="2" border="1">
  <tr> 
      <td><a href="<?=$SCRIPT_NAME."?".makeListParms($offset, "id", $sortby=="id"?($dir=="asc"?"desc":"asc"):$dir, $displaysize, stripslashes($searchdata), $moreParams)?>">Id</a></td>
      <td><a href="<?=$SCRIPT_NAME."?".makeListParms($offset, "pollType", $sortby=="pollType"?($dir=="asc"?"desc":"asc"):$dir, $displaysize, stripslashes($searchdata), $moreParams)?>">PollType</a></td>
      <td><a href="<?=$SCRIPT_NAME."?".makeListParms($offset, "title", $sortby=="title"?($dir=="asc"?"desc":"asc"):$dir, $displaysize, stripslashes($searchdata), $moreParams)?>">Title</a></td>
  	    <td>Delete</td>
		    <td>&nbsp;</td>
	  </tr>
<?php   	$i = 0;
	while (($o = $oseq->getNextElement()) && ($i < $displaysize)) {
		$ogotone = 1;
		$i++;
?>  <tr> 
        <td> 
      <?=htmlspecialchars($o->getId())?>    </td>
	    <td> 
      <?=htmlspecialchars($POLLTYPES[$o->getPollType()])?>    </td>
	    <td> 
      <?=htmlspecialchars($o->getTitle())?>    </td>
		    <td>
      <input type="checkbox" name="deleteids[]" value="<?=$o->getId()?>">
    </td>
		    <td><a href="<?=$detailurl.$detailurlsepchar."id=".$o->getId()?>">Detail</a></td>
	  </tr>
<?php   }
	if (!$ogotone) {
?>  <tr> 
    <td colspan="5">No records found.</td>
  </tr>
<?php 	} else {
?>  <tr> 
    <td colspan="5"> 
      <table width="100%" border="0" cellspacing="0" cellpadding="4">
        <tr valign="top"> 
          <td align="left"> 
<?php 			if ($offset > 0) {
?>            <a href="<?=$SCRIPT_NAME."?".makeListParms(max(0, $offset-$displaysize), $sortby, $dir, $displaysize, stripslashes($searchdata), $moreParams)?>">&lt;&lt; 
            Back</a> 
<?php 			}
?>          </td>
          <td> &nbsp;&nbsp;&nbsp; </td>
          <td align="right"> 
<?php 			if ($o) {
?>            <a href="<?=$SCRIPT_NAME."?".makeListParms($offset+$displaysize, $sortby, $dir, $displaysize, stripslashes($searchdata), $moreParams)?>">Next 
            &gt;&gt;</a> 
<?php 			}
?>          </td>
        </tr>
      </table>
    </td>
  </tr>
<?php 	}
?></table>
  <p> 
      <input type="submit" name="add" value="Add">
        <input type="submit" name="update" value="Update">
      <input type="hidden" name="offset" value="<?=$offset?>">
    <input type="hidden" name="dir" value="<?=$dir?>">
    <input type="hidden" name="sortby" value="<?=$sortby?>">
    <input type="hidden" name="displaysize" value="<?=$displaysize?>">
    <input type="hidden" name="action" value="update">
<?php 	foreach ($moreParams as $k => $v) {
?>    <input type="hidden" name="<?=htmlspecialchars($k)?>" value="<?=htmlspecialchars($v)?>">
<?php 	}
?>  </p>
</form>



</body>
</html>
