
// Event options, should be pretty obvious
// All you do is assign a string with the function call text in it to the appropriate
// handler variable.  The variable "code" will contain the code (item name) of the
// cart item being updated, e.g., cart_beforeAdd = "myfunc(code, 'customvar')";
var cart_beforeAdd = '';         // f(code)
var cart_afterAdd = '';          // f(code)
var cart_beforeUpdate = '';      // f(code)
var cart_afterUpdate = '';       // f(code)
var cart_beforeRemove = '';      // f(code)
var cart_afterRemove = '';       // f(code)

// Internal helpers
function cart_getCookieValue() {
	var re = /\b(cartValue=([^;]*))/;
	var ret = re.exec(document.cookie);
	if (ret) {
		return ret[2];
	} else {
		return '';
	}
}
function cart_setCookieValue(v) {
	document.cookie = "cartValue=" + v;
}

// Helper - rounds a floating point number to the second decimal place and formats it as
// a string with two decimal places.  Used for output prices and other currency values.
function cart_roundToCent(amt) {
	// Do the actual mathematical round
	amt = parseFloat(Math.round(parseFloat(amt) * 100))/100;
	// Format it so it looks nice with two decimal places
	var s = new String(amt);
	if (s.indexOf(".") >= 0) {
		s += '00';
	} else {
		s += '.00';
	}
	var pos = s.indexOf(".");
	amt = s.substr(0, pos+3);
	return amt;
}

/////////////////////////////// Public cart handling functions //////////////////////////////

// General cart manipulation
function cart_add(code, description, fullprice, discountprice, qty) {
	qty = parseInt(qty);
	if (cart_hasCode(code)) {
		var newqty = cart_getQty(code) + qty;
		if (newqty < 1) {
			cart_remove(code);
		} else {
			cart_update(code, newqty);
		}
	} else {
		var c = cart_getCookieValue();
		if (c) { c = c + "|"; }
		c = c + code + "~" + description + "~" + fullprice + "~" + discountprice + "~" + qty;
		// Call before handler
		eval(cart_beforeAdd);
		cart_setCookieValue(c);
		// Call after handler
		eval(cart_afterAdd);
	}
}
function cart_update(code, qty) {
	if (qty == 0) {
		cart_remove(code);
		return;
	}
	var re = new RegExp("((\\|)?"+code+"~[^~]+~[^~]+~[^~]+~)([^|]+)((\\|)?)");
	var c = cart_getCookieValue();
	var ret = re.exec(c);
	c = c.replace(re, ret[1] + qty + ret[4]);
	// Call before handler
	eval(cart_beforeUpdate);
	cart_setCookieValue(c);
	// Call after handler
	eval(cart_afterUpdate);
}
function cart_incrementQty(code) {
	cart_update(code, cart_getQty(code) + 1);
}
function cart_decrementQty(code) {
	cart_update(code, cart_getQty(code) - 1);
}
function cart_remove(code) {
	var re = new RegExp("(\\|)?"+code+"~[^|]+(\\|)?");
	var c = cart_getCookieValue();
	c = c.replace(re, "|");
	if (c.charAt(0) == '|' ) {
		c = c.substr(1);
	}
	if (c.charAt(c.length - 1) == "|") {
		c = c.substr(0, c.length - 1);
	}
	// Call before handler
	eval(cart_beforeRemove);
	cart_setCookieValue(c);
	// Call after handler
	eval(cart_afterRemove);
}
function cart_hasCode(code) {
	var re = new RegExp("((\\|)?"+code+"~[^~]+~[^~]+~[^~]+~)([^|]+)((\\|)?)");
	var c = cart_getCookieValue();
	var ret = re.exec(c);
	if (ret) {
		return true;
	} else {
		return false;
	}
}
function cart_getValues(code) {
	var re = new RegExp("(\\|)?"+code+"~([^~]+)~([^~]+)~([^~]+)~([^|]+)((\\|)?)");
	var c = cart_getCookieValue();
	var ret = re.exec(c);
	if (ret) {
		var o = new Object();
		o.code = code;
		o.description = ret[2];
		o.fullPrice = parseFloat(ret[3]);
		o.discountPrice = parseFloat(ret[4]);
		o.qty = parseInt(ret[5]);
		o.totalFullPrice = o.fullPrice * o.qty;
		o.totalDiscountPrice = o.discountPrice * o.qty;
		return o;
	} else {
		return null;
	}
}
function cart_getDescription(code) {
	var o = cart_getValues(code);
	return o.description;
}
function cart_getFullPrice(code) {
	var o = cart_getValues(code);
	return o.fullPrice;
}
function cart_getDiscountPrice(code) {
	var o = cart_getValues(code);
	return o.discountPrice;
}
function cart_getQty(code) {
	var o = cart_getValues(code);
	return o.qty;
}
function cart_getCodes() {
	var c = cart_getCookieValue();
	var vs = c.split("|");
	if (vs[0].length == 0) {
		vs = new Array;
		//alert(vs.length);
	}
	var i;
	var ar = new Array;
	for (i = 0; i < vs.length; i++) {
		var o = (vs[i]).split("~");
		ar[i] = o[0];
	}
	return ar;
}
function cart_getTotals() {
	var codes = cart_getCodes();
	var i;
	var ret = new Object();
	ret.totalFullPrice = 0;
	ret.totalDiscountPrice = 0;
	ret.totalQty = 0;
	for (i = 0; i < codes.length; i++) {
		var o = cart_getValues(codes[i]);
		ret.totalFullPrice += parseFloat(o.totalFullPrice);
		ret.totalDiscountPrice += parseFloat(o.totalDiscountPrice);
		ret.totalQty += parseInt(o.qty);
	}
	return ret;
}
function cart_isEmpty() {
	return cart_getCookieValue() == '';
}
function cart_empty() {
	if (cart_getCookieValue() != '') {
		code = null;
		eval(cart_beforeRemove);
		cart_setCookieValue('');
		eval(cart_afterRemove);
	}
}
