require File.dirname(__FILE__) + '/../test_helper'

class UserTest < Test::Rails::TestCase
  fixtures :users, :comments, :support_materials, :readings, :topics
  
  def test_admin_permissions
    assert_permitted(:laura, [:see_future_topic, :topics_edit, :topic_approve, :topics_hold])
  end

  def test_expert_permissions
    assert_permitted(:frank, [:see_future_topic, :topics_edit, :topics_new, :see_held_topic])   
    assert_not_permitted(:frank, [:topic_approve, :topics_hold])
  end
  
  
  def test_mark_support_material_read
    assert_difference(Reading, :count) do
      users(:ernest).record_read_of support_materials(:cc)
    end
  end

  def test_mark_support_material_only_records_first_read
    assert_difference(Reading, :count) do
      users(:ernest).record_read_of support_materials(:cc)
      users(:ernest).record_read_of support_materials(:cc)
    end
  end


  def test_mark_comment_read
    assert_difference(Reading, :count) do
      users(:ernest).record_read_of comments(:long_first_post)
    end
  end
  
  def test_mark_doesnt_apply_to_admin
    assert_no_difference(Reading, :count) do
      users(:laura).record_read_of comments(:long_first_post)
      users(:laura).record_read_of support_materials(:cc)
    end
  end
  
  def test_topics_find
    assert_nothing_raised do
      users(:ernest).topics_find(:all)
      users(:laura).topics_find(:all)
      users(:frank).topics_find(:all)
    end
  end
  
  protected
  def create_user(options = {})
    User.create({ :email => 'quire@example.com', :password => 'quire', :password_confirmation => 'quire' }.merge(options))
  end
  
  def assert_permitted(user, activities)
    u = users(user)
    activities.each do |activity|
      assert u.has_permission_to?(activity), "should have permitted #{activity}"
    end
  end
  
  def assert_not_permitted(user, activities)
    u = users(user)
    activities.each do |activity|
      assert !u.has_permission_to?(activity), "should not have permitted #{activity}"
    end
  end
end
