require File.dirname(__FILE__) + '/../test_helper'

class TopicTest < Test::Rails::TestCase
  fixtures :topics, :users, :comments, :ratings

  def test_fixture
    assert_kind_of Topic, topics(:direct_democracy)
  end
  
  def test_author
    assert_kind_of User, topics(:direct_democracy).expert
    assert_equal 'Frank', topics(:direct_democracy).expert.name
  end
  
  def test__start_date_required
    assert_invalid(topics(:direct_democracy), :start_date, [nil, ''])
  end
  
  def test_expert_required
    topic_with_no_expert =  Topic.new
    assert !topic_with_no_expert.save
    assert topic_with_no_expert.errors.on('expert')
  end
  
  def test_expert_must_be_valid
    topic_with_no_expert =  Topic.new(:expert_id => 999999)
    assert !topic_with_no_expert.save
    assert topic_with_no_expert.errors.on('expert')
  end
  
  def test_new_topics_not_approved
    t = Topic.new(topics(:direct_democracy).attributes)
    assert t.save
    assert !t.approved?
  end
  
  def test_topics_have_comments
    create_fixtures :comments
    assert topics(:direct_democracy).comments
    assert_equal 4, topics(:direct_democracy).comments.count
  end
  
  def test_commentable_eh
    assert topics(:direct_democracy).commentable?
    assert !topics(:senate_reform).commentable? # in the past, but being held
    assert !topics(:guilty_looks).commentable?  # approved, but still in the future
  end
  
  def test_yesterday_is_not_the_future
    assert !Topic.new(:start_date => 1.day.ago.to_date).for_future?
  end
  
  def test_today_is_not_the_future
    assert !Topic.new(:start_date => Date.today).for_future?
  end
  
  def test_tommorow_is_the_future
    assert Topic.new(:start_date => 1.day.from_now.to_date).for_future?    
  end
  
  def test_topic_comments_word_total
    assert_equal 9, topics(:direct_democracy).comments.total_words
  end
  
  def test_find_three_most_read_comments
    assert_nothing_raised { topics(:senate_reform).comments.find_three_most_read }
    assert_equal comments(:long_first_post), topics(:senate_reform).comments.find_three_most_read.first
  end
  
  def test_find_three_best_avg_rating_comments
    assert_nothing_raised { topics(:direct_democracy).comment_ratings.best_average_rated_subject_ids }
    assert_equal comments(:day_old_reply).id, topics(:direct_democracy).comment_ratings.best_average_rated_subject_ids.first
  end
  
  def test_reduce_to_best_rated
    best = Topic::reduce_to_best_rated(Topic.find([1,2,3])) # 2 has no ratings
    assert_equal topics(:direct_democracy).id, best.id
  end
  
  # TODO: copy find_for_user tests from medusa branch
end
