require File.dirname(__FILE__) + '/../test_helper'

class TopicRatingTest < Test::Rails::TestCase
  fixtures :ratings, :topics, :users
    
  def test_ratings_are_dependent_on_topic
    assert_difference(TopicRating, :count, '', -2) do
      Topic.destroy(topics(:direct_democracy).id)
    end    
  end

  def test_create_comment_rating
    assert_valid TopicRating.new(:user => users(:grace), :subject => topics(:direct_democracy), :value => 1)
  end
  
  def test_created_with_given_user
    assert_equal users(:grace), TopicRating.create(:user => users(:grace), :subject => topics(:direct_democracy), :value => 5).user
  end
  
  def test_cannot_rate_comment_twice
    assert_no_difference(TopicRating, :count) do
      TopicRating.create(:user => users(:ernest), :subject => topics(:direct_democracy), :value => 5)
    end
  end
    
end
