require File.dirname(__FILE__) + '/../test_helper'

class AbstractRatingTest < Test::Rails::TestCase
  fixtures :ratings, :comments, :users, :topics, :readings, :support_materials

  [Admin, 
  Comment, 
  CommentRating, 
  Expert, 
  Guest, 
  MaterialConvincingRating, 
  MaterialInformativeRating, 
  Participant, 
  Reading,
  RegisteredUser,
  Snippet,
  SupportMaterial,
  Topic, 
  TopicRating, 
  User].each do |model|
    define_method("test_#{model}_associations") do
      assert check_associations(model)
    end
  end  
  
end