require File.dirname(__FILE__) + '/../test_helper'
require 'snippets_controller'

# Re-raise errors caught by the controller.
class SnippetsController; def rescue_action(e) raise e end; end

class SnippetsControllerTest < Test::Rails::TestCase
  
  fixtures :users, :snippets
  
  def setup
    @controller = SnippetsController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
  end

  
  # only admin can access the actions other than index
  def test_redirect_participant
    login_as :ernest # a participant
    [:set_snippet_body, :get_snippet_body].each do |action| 
      get action
      assert_response :redirect
    end
  end

  def test_redirect_expert
    login_as :frank # an editor
    [:set_snippet_body, :get_snippet_body].each do |action| 
      get action
      assert_response :redirect
    end
  end
  
  def test_all_can_access_show_by_name
    [:laura, :frank, :ernest].each do |user|
      login_as user
      get :show_by_name, :name => 'about'
      assert_response :success
    end
  end
  
  def test_name_required
    login_as :ernest # a participant
    assert_raises(ActiveRecord::RecordNotFound) { get :show_by_name }
  end
  
  def test_show_by_name_sets_a_snippet
    login_as :ernest # a participant
    get :show_by_name, :name => 'about'
    assert assigns(:snippet)
    assert_kind_of Snippet, assigns(:snippet)
  end
end
