require File.dirname(__FILE__) + '/../test_helper'
require 'rater_controller'

# Re-raise errors caught by the controller.
class RaterController; def rescue_action(e) raise e end; end

class RaterControllerTest < Test::Rails::TestCase
  
  fixtures :users, :comments, :support_materials, :topics, :settings, :ratings
  
  def setup
    @controller = RaterController.new
    @request    = ActionController::TestRequest.new
    @response   = ActionController::TestResponse.new
    @request.env["HTTP_REFERER"] = 'http://localhost/'
  end

  # only participants can rate
  def test_expert_cannot_rate
    login_as :frank # an editor
    assert_no_difference(AbstractRating, :count) { create_ratings }
  end
  
  def test_admin_cannot_rate
    login_as :laura # an admin
    assert_no_difference(AbstractRating, :count) { create_ratings }
  end
  
  def test_guest_can_rate
    login_as :visitor1 # a guest
    assert_difference(AbstractRating, :count, nil, 4) { create_ratings }
  end
  
  def test_participants_can_rate
    AbstractRating.delete_all
    login_as :grace # a participant
    assert_difference(AbstractRating, :count, nil, 4) { create_ratings }
  end
  
  def test_create_rating_puts_js_in_flash
    login_as :visitor1
    get 'create', :subject_id => 1, :value => 1, :rating_type => "topic_rating"
    
    assert flash[:javascript]
    assert_match "/funnel/rating/success?type=Topic&amp;id=1", flash[:javascript]
  end
  
  private
  
    def create_ratings
      [:topic_rating, :comment_rating, :material_convincing_rating, :material_informative_rating].each do |rating_type| 
        get 'create', :subject_id => 1, :value => 1, :rating_type => rating_type.to_s
      end      
    end
end
