require File.dirname(__FILE__) + '/../test_helper'
require 'mocha'
require 'stubba'

class ViewerControllerTest < Test::Rails::ControllerTestCase

  fixtures :topics, :users, :settings, :support_materials, :readings
  
  def setup
    super
    login_as :quentin
  end
  
  def test_index
    get :index, :id => support_materials(:google).id
    assert_response :success # Assert we got a 200
  end  
  
  def test_index_raises_reading
    assert_difference(Reading, :count) do
      get :index, :id => support_materials(:google).id
    end   
  end
  
  def test_index_with_link
    get :index, :id => support_materials(:google).id
    assert_assigned :content_url, support_materials(:google).url
  end

  def test_index_with_file
    get :index, :id => support_materials(:uploaded_file).id
    assert_assigned :content_url, "http://test.host/viewer/content/#{support_materials(:uploaded_file).id}"
  end
  
  def test_header
    get :header, :id => support_materials(:google).id
    assert_response :success # Assert we got a 200
    assert_equal support_materials(:google), assigns(:informative_rating).subject  
    assert_equal support_materials(:google), assigns(:convincing_rating).subject  
    assert_equal users(:quentin), assigns(:informative_rating).user  
    assert_equal users(:quentin), assigns(:convincing_rating).user  
  end
  
  def test_content_pdf
    get_content(support_materials(:pdf))

    assert_response :success  
    assert_equal 'application/pdf; charset=utf-8',
                 @controller.headers['Content-Type']
    assert_equal %Q{inline; filename="#{support_materials(:pdf).filename}"}, 
                 @controller.headers['Content-Disposition']
  end
  
  def test_content_html
    get_content(support_materials(:uploaded_file))
    
    assert_response :success
    assert_equal 'text/html; charset=utf-8', @controller.headers['Content-Type']
  end
  
 private
  # stub File to grease the wheels and then call the content action for the given
  # support material
  def get_content(support_material)
    stub_file_for(support_material.full_filename)
    get :content, :id => support_material.id    
  end
  
  # stubs some calls to File so that we can test the rest of send_file
  def stub_file_for(path)
    File.stubs(:file?).returns(true)
    File.stubs(:readable?).with(path).returns(true)
    File.stubs(:size).with(path).returns(3)
  end
end