# from procreate
require "yaml"

namespace :db do
  desc "Launch database console."
  task :console => [:load_db_config] do
    case @db_config["adapter"]
    when "postgresql"
      # use .pgpass if you don't want to enter your password
      cmd = "psql #{@db_config["database"]} #{@db_config["username"]}"
      
    when "mysql"
      cmd = "mysql -u#{@db_config["username"]} --password #{@db_config["password"]} #{@db_config["database"]}"
      
    end
    exec cmd
  end

  task "load_db_config" do
    ENV["RAILS_ENV"] ||= "development"
    @db_config = YAML::load_file("#{RAILS_ROOT}/config/database.yml")[ENV["RAILS_ENV"]]
  end
  
  desc "Dump the database to an SQL file"
  task :backup => [:load_db_config] do
    ENV["RAILS_ENV"] ||= "development"
    exec "mysqldump --add-drop-table -e -u #{@db_config['username']} --password=#{@db_config['password']} #{@db_config['database']} > #{@db_config['database']}.sql"
  end
end
