class UsersGetAverageRating < ActiveRecord::Migration
  def self.up
    add_column :users, :avg_rating, :float
    RegisteredUser.reset_column_information
    say_with_time "Setting User avg_rating cache..." do
      RegisteredUser.find(:all).each { |user| user.update_average_rating_cache }
    end
  end

  def self.down
    remove_column :users, :avg_rating
  end
end
