class CommentsGetAverageRatingField < ActiveRecord::Migration
  def self.up
    add_column :comments, :avg_rating, :float
    Comment.reset_column_information
    say_with_time "Setting Comment avg_rating cache..." do
      Comment.find(:all).each do |comment|
        comment.update_average_rating_cache
      end
    end
  end

  def self.down
    remove_column :comments, :avg_rating
  end
end
