# counter_cache is a bit broken when the associated model has a reciprocated 
# has_many association.
# 
# see http://dev.rubyonrails.org/ticket/6197
#
# This migration works around this by modifying the DB so that the column is
# not shadowed.
class WorkAroundCounterCacheBug < ActiveRecord::Migration
  def self.up
    rename_column :comments, :readings_count, :reading_count

    Comment.reset_column_information
    say_with_time "Setting Comment reading_count cache..." do
      Comment.find(:all).each do |comment|
        comment.update_attribute(:reading_count, comment.readings.count)
      end
    end
  end

  def self.down
    rename_column :comments, :reading_count,  :readings_count
  end
end
