class SupportMaterialCanBePdf < ActiveRecord::Migration
  def self.up
    add_column :support_materials, :content_type, :string
    add_column :support_materials, :size,         :integer    
    add_column :support_materials, :parent_id,    :integer # apparently needed for acts_as_attachment
    rename_column :support_materials, :file, :filename

    SupportMaterial.reset_column_information
    SupportMaterial.update_all("content_type = 'text/html'", 'filename IS NOT NULL')
  end

  def self.down
    rename_column :support_materials, :filename, :file
    
    remove_column :support_materials, :parent_id
    remove_column :support_materials, :size
    remove_column :support_materials, :content_type
  end
end
