ActionController::Routing::Routes.draw do |map|
  # Add your own custom routes here.
  # The priority is based upon order of creation: first created -> highest priority.
  
  # Here's a sample route:
  # map.connect 'products/:id', :controller => 'catalog', :action => 'view'
  # Keep in mind you can assign values other than :controller and :action

  # You can have the root of your site routed by hooking up '' 
  # -- just remember to delete public/index.html.
  map.home '', :controller => "blog"
  
  map.topic 'topics/show/:id',       :controller => 'topics', :action => 'show'
  map.comment_read 'talk/mark/:id', :controller => 'talk',   :action => 'mark'
  map.remove_comment '/talk/remove_comment/:id', :controller => 'talk', :action => 'remove_comment'
  map.rating_create 'rater/create/:rating_type/:subject_id', :controller => 'rater', :action => 'create'
  
  map.register '/register/', :controller => 'account', :action => 'signup'
  map.map '/verify/:key', :controller => 'account', :action => 'verify_account'
  map.login '/login/',    :controller => 'account', :action => 'login'
  map.logout '/logout/',   :controller => 'account', :action => 'logout'

  map.rss '/rss/', :controller => 'topics', :action => 'rss'
  map.archives '/archives/', :controller => 'topics', :action => 'archives'
  
  # "pages"
  map.connect '/about',              :controller => 'snippets', :action => 'show_by_name', :name => 'about'
  map.connect '/privacy_policy',     :controller => 'snippets', :action => 'show_by_name', :name => 'privacy'
  map.about_feeds '/about_news_feeds',   :controller => 'snippets', :action => 'show_by_name', :name => 'about_feeds'
  map.connect '/opinion_leaders',    :controller => 'snippets', :action => 'show_by_name', :name => 'opinion_leaders'
  
  map.connect '/logged_exceptions/:action/:id', :controller => 'logged_exceptions' # plugin route not being picked up on edge rails (r5208)
  
  # Allow downloading Web Service WSDL as a file with an extension
  # instead of a file named 'wsdl'
  map.connect ':controller/service.wsdl', :action => 'wsdl'
  
  # Install the default route as the lowest priority.
  map.connect ':controller/:action/:id'
end
