module TopicPolicy
  def self.user_can_see_future_or_held_topics?(user)
    user && [:admin, :expert].include?(user.role)
  end   
  
  def self.topic_scope_for_user(user)
    if user_can_see_future_or_held_topics?(user)
      '1=1' # shouldn't really be needed but MySql was complaining: ActiveRecord::StatementInvalid: Mysql::Error: You have an error in your SQL syntax; check the manual that corresponds to your MySQL server version for the right syntax to use near ') AND (topics.id = 2)' at line 1: SELECT * FROM topics WHERE () AND (topics.id = 2)
    else
      ['approved = 1 && `start_date` <= ?', Date.today] 
    end
  end   
     
end