module ApplicationPolicy
  def self.participation_enabled?
    Settings.open
  end
  
  def self.user_can_view_closed_application?(user)
    user && [:admin, :expert].include?(user.role)
  end
  
  def self.show_support_material?
    true
  end
    
  def self.guests_allowed?
    true
  end
  
  def self.recording_user_numbers?
    false
  end
end