class UserNotifier < ActionMailer::Base
  def signup_notification(user)
    setup_email(user)
    bcc         "pierre.killeen@gmail.com, lee@omara.ca"
    @subject    += 'Thank you for registering' # TODO translation required
    @body[:url]  = [Settings.application_url, 'verify', user.login_key].join("/")
  end
  
  def password_reminder(user)
    setup_email(user)
    @subject   += 'Password reminder' # TODO translation required
    @body[:url]  = Settings.application_url 
  end
    
  # the notice sent to the writter of the comment being replied to
  def reply_notification(user, comment)
    setup_email(user)
    @subject   += "A new reply"
    @body[:url] = "#{Settings.application_url}/topics/show/#{comment.topic_id}#comment_#{comment.id}"
  end
    
  protected
  def setup_email(user)
    recipients  user.email_address_with_name
    from        Settings.admin_email
    subject     "[%s] " % Settings.email_subject_label
    sent_on     Time.now
    body        :user => user
  end
end
