# Schema as of Mon Nov 27 15:17:56 EST 2006 (schema version 35)
#
#  id                  :integer(11)   not null
#  name                :string(255)   
#  type                :string(255)   
#  email               :string(100)   
#  crypted_password    :string(40)    
#  salt                :string(40)    
#  created_at          :datetime      
#  bio                 :text          
#  picture             :string(255)   
#  user_number         :string(255)   
#  year_of_birth       :integer(11)   
#  gender              :integer(11)   default(0)
#  postal_code         :string(255)   
#  login_key           :string(255)   
#  verified            :boolean(1)    
#  login_key_expires_at:datetime      
#


class User < ActiveRecord::Base
  has_many :readings, :foreign_key => :participant_id, :dependent => :delete_all
  has_many :ratings, :foreign_key => :participant_id, :class_name => 'AbstractRating', :dependent => :delete_all
  has_many :comment_ratings, :foreign_key => :participant_id, :class_name => 'CommentRating', :dependent => :delete_all

  cattr_accessor :current_user    
  
  # This method is just a stand-in for a real role system.
  #
  # Since this project has simple permission requirements this approach
  # may suffice.
  def role
    self.class.to_s.downcase.to_sym
  end
  
  # change in descendants to include all prermitted activities
  def permitted_activities
    []
  end
  
  def has_permission_to?(do_something)
    permitted = permitted_activities.include? do_something
    logger.debug "checking permission for #{name} (#{role}) to #{do_something} -- " + (permitted ? "premitted" : "forbidden")
    return permitted
  end
  
  def record_read_of(what)
    # noop -- gets re-implemented by Guest, Participant class  
  end    

  def registered?
    false
  end
  
  # takes the same arguments as AR::find, but is scoped to the current user
  def topics_find(*args)
    Topic.with_scope(:find => {:conditions => TopicPolicy::topic_scope_for_user(self) }) do
      Topic.find *args
    end
  end 
  
end
