# Schema as of Mon Nov 27 15:17:56 EST 2006 (schema version 35)
#
#  id                  :integer(11)   not null
#  value               :integer(11)   default(0), not null
#  subject_id          :integer(11)   default(0), not null
#  participant_id      :integer(11)   
#  created_on          :datetime      not null
#  type                :string(255)   
#

class TopicRating < AbstractRating
  belongs_to :subject, :class_name => 'Topic', :foreign_key => 'subject_id'
  # TODO validates value between 1-5
  
  def mapping # Agree (1), Somewhat Agree (2), Unsure (77) Somewhat Disagree (3) Disagree (4)
    # TODO these strings should be stored as application settings
    [ 
      [1, 'Agree'], 
      [2, 'Somewhat Agree'], 
      [77, 'Unsure'],
      [3, 'Somewhat Disagree'],
      [4, 'Disagree']
    ]
  end
end
