# simple class to help keep our logic from spilling into the views/helpers
class MetricsGrid
  attr :values
    
  def initialize(data_source, &block)
    @values      = {}
    @bests       = {}
    @data_source = data_source
    yield(self)
  end
  
  def measure(attribute_name, best = :max, &block)
    @bests[attribute_name] = @data_source.collect do |record| 
      @values[record.id] ||= {}
      @values[record.id][attribute_name] = yield(record) 
    end.compact.send(best) rescue nil
  end
  
  def for_topic(topic)
    return @values[topic.id]
  end
  
  # does the given value match the best on record? Ignore nil
  def is_best?(attribute_name, value)
    value && @bests[attribute_name] == value
  end  
end
