# Schema as of Mon Nov 27 15:17:56 EST 2006 (schema version 35)
#
#  id                  :integer(11)   not null
#  name                :string(255)   
#  type                :string(255)   
#  email               :string(100)   
#  crypted_password    :string(40)    
#  salt                :string(40)    
#  created_at          :datetime      
#  bio                 :text          
#  picture             :string(255)   
#  user_number         :string(255)   
#  year_of_birth       :integer(11)   
#  gender              :integer(11)   default(0)
#  postal_code         :string(255)   
#  login_key           :string(255)   
#  verified            :boolean(1)    
#  login_key_expires_at:datetime      
#

class Expert < RegisteredUser
  has_many :topics
  file_column :picture # TODO replace with acts_as_attachement ASAP
  
  def permitted_activities
    [:see_future_topic, :topics_edit, :topics_new, :see_held_topic, :library_new, :library_edit, :library_remove]
  end
  
  def has_permission_to?(do_something)
    # There is nothing Nik can't do, despite his being an editor1
    return true if email == 'nnanos@sesresearch.com'
    super
  end

  def record_read_of(what)
    # noop
  end    
  
end
