class SnippetsController < ApplicationController
  before_filter :permision_required
  
  def index
    @snippets = Snippet.find(:all)
  end
  
  def show_by_name
    @snippet = Snippet.find_by_name(params[:name])
    raise ActiveRecord::RecordNotFound unless @snippet
  end
  
  def edit
    @snippet = Snippet.find(params[:id])
    @snippet.attributes = params[:snippet]
    
    if request.post? && @snippet.save
      flash[:notice] = "Snippet updated"
    end
  end
  
  def preview
    @snippet = Snippet.find(params[:id])
    @snippet.attributes = params[:snippet]
    render :inline => "<%= smarty_markdown @snippet.body %>"
  end
  
  private
  
  def action_requires_permission?
    action_name != 'show_by_name'
  end
end
