class ExpertsController < ApplicationController
  before_filter :permision_required 
  
  def index
    @experts = Expert.find(:all)
  end
  
  def new
    @expert = Expert.new(params[:expert])
    return unless request.post?
    if @expert.save
      redirect_to :action => 'index'
      flash[:notice] = "Expert Account Created"
    end
  end
  
  def edit
    @expert = Expert.find(params[:id])
    @expert.password = ''
    @expert.attributes = params[:expert]
    return unless request.post?
    if @expert.save
      redirect_to :action => 'index'
      flash[:notice] = "Expert Account Updated"
    end
  end

  private
  
  # Does the current action require any specific permission?
  def action_requires_permission?
    true # they all do
  end
  
end
