class BlogController < ApplicationController
  
  helper :topics, :comment

  def index
    @topics                  = current_user.topics_find(:all, :conditions => ['front_page_worthy = ?', true], :order => '`start_date` DESC', :limit => 5)
    # we only want to show activitity on fresh content, so we limit most-read and highest-rated 
    # to comments from the last week. Ideally we would limit the Reads and Ratings, but this is
    # close enough for now.
    Comment.with_scope(:find => {:conditions => ["#{Comment.table_name}.created_at > ?", 1.week.ago] }) do
      @most_read_comments      = Comment.find_three_most_read
      @highest_rated_comments  = Comment.find_three_highest_avg_rating
    end  
    @ten_best_rated_participants = Participant.find_ten_best_avg_rating
    @newest_comments             = Comment.find_three_newest
    @blog_font_page_greeting     = Snippet.find_or_create_by_name('blog_font_page_greeting')
  end
end
