require File.dirname(__FILE__) + '/../test_helper'
require 'mocha'
require 'stubba'

class UsersViewTest < Test::Rails::ViewTestCase
 
  def test_show
    our_user = stub(
      :name => 'Quentin', 
      :role       => :participant, 
      :created_at => 1.day.ago,
      :avatar     => nil
      )
    assigns[:profile]    = @current_user = our_user
    assigns[:comments]   = []
    assigns[:my_account] = stub(:name => 'my_account', :body => 'This is the My Accounts page')
    render :action => 'show'
    
    assert_match "Quentin", @response.body
    # assert_match 'Upload an avatar', @response.body # FIXME - cant figure out how to stub the call to current_user
  end
  
  def test_error_message_says_user
    user = Participant.new() # nothing set, breaks many validation requirements
    user.valid? # set errors
    assigns[:user] = user
    render :action => 'new'
    assert_match /[0-9]+ error(s)? prohibited this user from being saved/, @response.body
  end
  
 
end
