require File.dirname(__FILE__) + '/../test_helper'
require 'mocha'

class TopicsViewTest < Test::Rails::ViewTestCase

  fixtures :topics, :users, :settings, :comments
  
  def setup
    super
    ApplicationPolicy.stubs(:guests_allowed?).returns(true)
  end
 
  # testing the view for the index action of TopicsController
  def test_index
    render_index(topics(:direct_democracy))
    assert_links_to "/topics/show/#{topics(:direct_democracy).id}", "Read the full piece &raquo;"
  end
  
  def test_index_with_custom_link    
    render_index(topics(:guilty_looks))
    assert_links_to "/topics/show/#{topics(:guilty_looks).id}", "Read more! &raquo;"
  end

  def test_form_partial
    assigns[:topic]   = topics(:guilty_looks)
    assigns[:experts] = Expert.find(:all)
    render :partial => 'form'

    form_action = '/topics' # this is wrong, but it's what labeled_form_for returns in this test
    assert_input form_action, :text, "topic[title]" 
    assert_input form_action, :text, "topic[continue_reading]"
  end
  
  def test_archives
    assigns[:full_list_of_topics] = Topic.find(:all, :order => '`start_date` DESC')
    
    render :action => 'archives'    
  end
  
  def test_list_admin
    assigns[:full_list_of_topics] = Topic.find(:all, :order => '`start_date` DESC')
    assigns[:current_user] = stub(:has_permission_to? => true)
    render :action => 'list' 
    assert_links_to "/topics/new", "add topic"   
  end
  
  def test_show
    assigns[:topic]                  = Topic.find(:first)
    assigns[:topic_comments]         = Comment.find(:all, :limit => 5) 
    assigns[:most_read_comments]     = Comment.find(:all, :limit => 3)
    assigns[:highest_rated_comments] = Comment.find(:all, :limit => 3)

    assigns[:title]                  = "Foo (bar)"
    
    @topic_all_comments_by_id = {}
    Topic.find(:first).comments.find(:all, :include =>  [{:ratings => :user}, :user] ).each do |c| 
      @topic_all_comments_by_id[c.id] = c
    end
    assigns[:topic_all_comments_by_id] = @topic_all_comments_by_id
    
    assigns[:topic_all_comment_children_ids] = {1 => [2,3]}
    assigns[:topic_comment_count] = 3
    
    render :action => 'show'    
  end
  
  private
  
  def render_index(topic)
    # Instance variables necessary for this view
    assigns[:news]   = Snippet.find_or_create_by_name('news')
    assigns[:topics] = Topic.find(:all, :order => '`start_date` DESC', :limit => 5)
    assigns[:topic]  = topic

    # render this view
    render :action => 'index'
  end
  
end
