require File.dirname(__FILE__) + '/../test_helper'
require 'mocha'
require 'stubba'

class SearchViewTest < Test::Rails::ViewTestCase
 
 def test_search_shows_number_of_comments_found
   Comment.any_instance.stubs(:body).returns('stubbed_body')
   Comment.any_instance.stubs(:commenter_name).returns('stubbed_commenter_name')
   Comment.any_instance.stubs(:topic).returns(stub(:title => 'foo'))
   assigns[:comments] = Array.new(51).collect{Comment.new}
   assigns[:comment_total] = 51
   assigns[:comment_results] = stub_search_results(51, 2)

   render :action => "index"
     
   assert_match %r{51 comments found}, @response.body
 end

 def test_search_shows_number_of_comments_found_none_found
   assigns[:comments] =  Array.new(0)
   assigns[:comment_total] = 0
   assigns[:comment_results] = stub_search_results(0)

   render :action => "index"
     
   assert_match %r{No comments found}, @response.body
 end
 
 def stub_search_results(total, current_page = 1)
  stub(:current_page => current_page, 
    :page_count => (total/10).ceil + 1, 
    :per_page => 10, 
    :next_page => (current_page-1) * 10 < total ? current_page + 1 : nil, 
    :previous_page => (current_page == 1 ? nil : current_page - 1), 
    :total => total)
 end
end
