require File.dirname(__FILE__) + '/../test_helper'
require 'mocha'
require 'stubba'

# We are testing AccountController's views
class AccountViewTest < Test::Rails::ViewTestCase
 
  def test_login_rjs_succeed
    assigns[:current_user] = stub(:registered? => true, :name => 'Quentin', :role => :participant, :guest? => false)

    render :template => 'account/login.rjs'
    
    assert_match "Quentin", @response.body
    assert_match '$("navbar").update', @response.body
    assert_match '$("userbar").update', @response.body
    
    # assert_match %r{/funnel/account/login/success}, @response.body   
  end

 def test_login_rjs_fail
   assigns[:current_user] = stub(:registered? => false)
   assigns[:message]      = 'Invalid login';

   render :template => 'account/login.rjs'
   
   assert_match 'alert("Invalid login");', @response.body   
   # assert_match %r{/funnel/account/login/failure}, @response.body   
 end
 
 def test_signup_rjs_success
   assigns[:current_user] = stub(:registered? => true, :name => 'Quentin', :role => :participant, :guest? => false)

   render :template => 'account/signup.rjs'
   
   assert_match "Quentin", @response.body
   assert_match '$("navbar").update', @response.body
   assert_match '$("userbar").update', @response.body
   
   # assert_match %r{/funnel/account/registration/success}, @response.body   
 end
 
 def test_signup_rjs_fail
   assigns[:current_user] = stub(:registered? => false)
   assigns[:user] = stub(:errors => stub(:full_messages => ['foo!']))

   render :template => 'account/signup.rjs'
   
   assert_match %r{alert\("Invalid Registration}, @response.body   
   
   # assert_match %r{/funnel/account/registration/failure}, @response.body     
 end
 
end
