require "test/unit"

require File.expand_path(File.dirname(__FILE__) + "/../../lib/zip_code")

class TestZipCode < Test::Unit::TestCase
  # http://en.wikipedia.org/wiki/List_of_ZIP_Codes_in_the_United_States
    
  def test_Massachusetts
    assert_equal "MA", ZipCode::state("01000")
    assert_equal "MA", ZipCode::state("02799")
    assert_equal "MA", ZipCode::state("02799")
  end
  
  def test_Georgia
    assert_equal("GA", ZipCode::state("30000"))
    assert_equal("GA", ZipCode::state("39800"))
    # assert_zip('GA', '39901')
  end
  
  def test_unknown_code
    assert_nothing_raised { ZipCode::state('00000') }
  end
  
  def test_NewYork
    assert_zip("NY", '10000')
    # assert_zip("NY", '06390') # an exception
    # assert_zip("NY", '00501') # an exception
    # assert_zip("NY", '00544') # an exception
  end
  
  def test_DC
    assert_zip("DC", '20000')
    assert_zip("DC", '20200')
    assert_zip("DC", '20599')
    assert_zip("DC", '56900')
  end
  
  def test_Virginia
    assert_zip('VA', '20100')
    assert_zip('VA', '22200')
    assert_zip('VA', '24699')
  end
  
  def test_Texas
    assert_zip('TX', '75000')
    assert_zip('TX', '79999')
    assert_zip('TX', '88500')
    assert_zip('TX', '88599')
  end
  
  def test_Wyoming
    assert_zip('WY', '82000')
    assert_zip('WY', '83199')
    # assert_zip('WY', '83414')
    
  end
  def assert_zip(state_code, zip_code)
    assert_equal(state_code, ZipCode::state(zip_code), "failed to match '#{zip_code}'")
  end
end