require File.dirname(__FILE__) + '/../test_helper'

class UserObserverTest < Test::Rails::TestCase
  fixtures :users

  def setup
    @emails = ActionMailer::Base.deliveries 
    @emails.clear
  end
  
  def test_after_create_should_send_email
    assert_difference(@emails, :length) { create_user }
  end
  
  def test_after_create_should_generate_new_access_passes
    RegistrationFilterItem.expects(:generate_new_access_passes_for_user!)
    create_user
  end
  
 private
  
  def create_user(options = {})
    RegisteredUser.create({ :email => 'quire@example.com', :password => 'quire', :password_confirmation => 'quire' }.merge(options))
  end
 
end