require File.dirname(__FILE__) + '/../test_helper'
require 'functional_test_matrix'

class TopicPolicyTest < Test::Rails::TestCase
  extend FunctionalTestMatrix
  
  matrix :policy,      :guest,  :participant, :expert, :admin
  # action :can_view,    :OK,     :OK,          :OK,     :OK
  # action :cannot_view, :fail,   :OK,          :OK,     :OK
  action :see_future,  :fail,   :fail,        :OK,     :OK
  
  def matrix_init_policy(role)
    @user = stub(:role => role, :guest? => (role == :guest))
  end
  
  # def matrix_setup_can_view(setup, expected)
  #   @topic    = stub(:guests_can_view? => true)
  #   @response = TopicPolicy::user_can_view_without_login?(@topic,@user)
  # end
  # 
  # def matrix_setup_cannot_view(setup, expected)
  #   @topic    = stub(:guests_can_view? => false)
  #   @response = TopicPolicy::user_can_view_without_login?(@topic,@user)
  # end
  
  def matrix_setup_see_future(setup, expected)
    @response = TopicPolicy::user_can_see_future_or_held_topics?(@user)
  end
  
  # def matrix_test_can_view(setup)
  #   assert @response
  # end
  # 
  # def matrix_test_cannot_view(setup)
  #   assert @response
  # end
  
  def matrix_test_see_future(setup)
    assert @response
  end
  
  def matrix_test_fail(setup)
    assert !@response
  end
  
end
