require File.dirname(__FILE__) + '/../test_helper'

class TopicObserverTest < Test::Rails::TestCase
  fixtures :topics, :users
  
  def setup
    WhitelistFilterItem.delete_all
    AccessPass.delete_all
  end
  
  def test_after_create_should_create_access_pass_for_expert
    assert_difference(WhitelistFilterItem, :count) do
      assert_difference(AccessPass, :count) do
        create_topic
      end
    end
  end
  
  def test_new_white_list_is_for_expert
    create_topic
    wl_item = WhitelistFilterItem.find(:first)
    assert_equal users(:frank).email, wl_item.value
  end
  
  def test_new_access_pass_is_for_expert
    create_topic
    ap = AccessPass.find(:first)
    assert_equal users(:frank), ap.user
  end
  
  def test_does_not_create_duplicate_white_list
    t = Topic.find(1)
    t.whitelist_filter_items.create(:value => users(:frank).email)
    assert_no_difference(WhitelistFilterItem, :count) { t.save! }
  end
  
 private
  
  def create_topic(options = {})
    Topic.create(topics(:direct_democracy, :expert => users(:frank)).attributes.merge(options))
  end
  
end