require "test/unit"

require File.expand_path(File.dirname(__FILE__) + "/../../lib/states")

class TestStates < Test::Unit::TestCase  
  def test_full_name
    assert_equal "New York", States::full_name("NY")
    assert_equal "Rhode Island", States::full_name("RI")
  end
  
  def test_full_name_returns_nil_for_unrecognized
    assert_nothing_raised() { States::full_name("COUCH") }
    assert_nil(States::full_name("frank"))
  end
end