require File.dirname(__FILE__) + '/../test_helper'

class RatingSpecificationTest < Test::Rails::TestCase
  fixtures :ratings, :users, :comments, :topics, :support_materials

  def test_subject_rateable
    [comments(:first_post), topics(:direct_democracy),support_materials(:google)].each do |subject|
      assert RatingSpecification::subject_rateable(subject, users(:grace)), "#{subject} should be rateable"
    end
  end

  def test_subject_rateable_topic_in_future
    [topics(:guilty_looks), support_materials(:cc)].each do |subject|
      assert !RatingSpecification::subject_rateable(subject, users(:grace)), "#{subject} should not be rateable"
    end
  end

  def test_not_already_rated
    rated_by_ernest.each do |subject, rating_class|
      assert !RatingSpecification::not_already_rated(subject, users(:ernest), rating_class), "ernest has rated #{subject} #{rating_class}"
    end
  end
  
  def test_not_already_rated_so
    rated_by_ernest.each do |subject, rating_class|
      assert RatingSpecification::not_already_rated(subject, users(:grace), rating_class), "#{subject} has been rated (#{rating_class})"
    end
  end
  
  def test_not_self_rating
    assert RatingSpecification::user_not_self_rating(comments(:first_post), users(:grace), CommentRating)
  end
  
  def test_self_rating
    assert !RatingSpecification::user_not_self_rating(comments(:first_post), users(:ernest), CommentRating)
  end
  
  def test_not_self_rating_non_comment
    [topics(:direct_democracy), support_materials(:google)].each do |subject|
      assert RatingSpecification::user_not_self_rating(subject, users(:ernest))
    end
  end
  
  def test_user_is_a_participant_or_guest
    [:ernest, :visitor1, :registered_guest].each do |user|
      all_rating_types.each do |subject, rating_class|
        assert RatingSpecification::user_is_a_participant_or_guest(subject, users(user), rating_class), "#{user} should be able to see a new rating #{subject}"
      end
    end
  end
  
  def test_user_is_not_a_registered_guests
    all_rating_types.each do |subject, rating_class|
      assert !RatingSpecification::user_is_not_a_registered_guests(subject, users(:registered_guest), rating_class), ":registered_guest should not be able to rate #{subject}"
    end
  end
  
  def test_participant_and_guest_can_rate
    [:ernest, :visitor1].each do |user|
      all_rating_types.each do |subject, rating_class|
        assert RatingSpecification::user_is_not_a_registered_guests(subject, users(user), rating_class), "#{user} should be able to rate #{subject}"
      end
    end
  end
  
  def test_passes_all_success
    [:grace, :visitor1].each do |user|
      assert RatingSpecification::passes_all?(comments(:first_reply), users(user)), "#{user} should be able to rate"
    end
  end

  def test_passes_all_fail
    rated_by_ernest.each do |subject, rating_class|
      assert RatingSpecification::passes_all?(subject, users(:ernest)), "ernest shoul not be able to rate #{subject}"
    end
  end
  
  def all_rating_types
    [
      [comments(:day_old_reply),     CommentRating            ], 
      [topics(:direct_democracy),  TopicRating              ],
      [support_materials(:google), MaterialConvincingRating ],
      [support_materials(:google), MaterialInformativeRating]
    ]    
  end
  
  def rated_by_ernest
    all_rating_types   
  end
end
