require File.dirname(__FILE__) + '/../test_helper'
require 'models/message'

class MessageTest < Test::Rails::TestCase
  def test_deliver!
    create_fixtures :users
    ApplicationPolicy.stubs(:can_send_message_to?).returns(true)
    UserMessager.expects(:deliver_user_message).returns(true)
    
    assert Message.new(User.find(1), User.find(2), 'hey there').deliver!
  end
  
  def test_deliver_bang_not_allowed
    ApplicationPolicy.stubs(:can_send_message_to?).returns(false)
    
    assert !Message.new(1, 2, 3).deliver!
  end
  
  def test_deliver_bang_fail
    ApplicationPolicy.stubs(:can_send_message_to?).returns(true)
    UserMessager.expects(:deliver_user_message).returns(false)
    
    assert !Message.new(1, 2, 3).deliver!
  end
end