require File.dirname(__FILE__) + '/../test_helper'

class AvatarTest < Test::Rails::TestCase
  fixtures :avatars, :users
  
  def test_create_over_existing_displaces_old
    assert_no_difference(Avatar, :count) do
      quentin = users(:quentin)
      old_avatar_id = quentin.avatar.id
      assert old_avatar_id
      
      quentin.avatar.create(:uploaded_data => fixture_file_upload('files/AA_pirate!.jpg', 'image/jpeg'))
      
      assert old_avatar_id != quentin.avatar.reload.id
      assert_raises(ActiveRecord::RecordNotFound){Avatar.find(old_avatar_id)}
    end
  end
end
