require File.dirname(__FILE__) + '/../test_helper'

class AbstractRatingTest < Test::Rails::TestCase
  fixtures :ratings, :comments, :users, :topics, :support_materials
  
  # poor approximation of test matrix
  %w{best_average_rated_subject_id best_average_rated_subject_ids}.each do |method_name|
    [
      ['normal',      lambda {}],
      ['no_ratings',  lambda {AbstractRating.delete_all}],
    ].each do | situation, setup_action|
      define_method("test_#{method_name}_not_exlosive_when_#{situation}") do
        setup_action.call
        assert_nothing_raised { AbstractRating.send(method_name)}
      end
    end
  end
  
  def test_best_average_rated_subject_ids_returns_three_ids
    results = AbstractRating.best_average_rated_subject_ids
    assert_equal 3, results.length
  end
  
  def test_best_average_rated_subject_ids_returns_n_ids
    results = AbstractRating.best_average_rated_subject_ids(5)
    assert_equal 5, results.length
  end
  
  def test_best_average_rated_subject_ids_correct_results
    results = AbstractRating.best_average_rated_subject_ids
    assert_equal [1, 2, 4], results
  end
  
  def test_move_to_new_user_no_net_change
    assert_no_difference(Reading, :count) do
      AbstractRating.move_to_new_user(users(:visitor1), users(:ernest))
    end
  end

  def test_move_to_new_user_readings_moved
    assert_difference(users(:visitor1).ratings, :count, '', -1) do
      assert_difference(users(:ernest).ratings, :count, '', 1) do
        AbstractRating.move_to_new_user(users(:visitor1), users(:ernest))
      end
    end
  end
  
  def test_ratings_dependent_on_user
    assert_difference(AbstractRating, :count, '', -6) do
      users(:ernest).destroy
    end
  end
  
  %w{comment topic material_convincing material_informative}.each do |rating_type|
    define_method("test_create_for_user_with_type_#{rating_type}") do
      assert_difference(AbstractRating, :count) do
        AbstractRating::create_for_user_with_type(users(:quentin), "#{rating_type}_rating", 1, 1)
      end
    end
  end
  
  def test_is_a_rating_not_explosive_when_given_illegal_type
    assert_nothing_raised do
      AbstractRating::is_a_rating?('cat_rating')
    end
  end
  
  def test_report
    assert_nothing_raised do
      AbstractRating::report
    end
  end
end
