require File.dirname(__FILE__) + '/../test_helper'

class ApplicationHelperTest < Test::Rails::HelperTestCase

  include ApplicationHelper
  include UniformLinkHelper

  fixtures :users, :topics
    
  def test_topic_box_future_topics
    @current_user = users(:laura)
    output = topic_box([topics(:guilty_looks)])
    assert_match '(not yet available)', output
    assert_match 'add topic', output
  end
  
  def test_snippets_nil_body
    assert_nothing_raised { snippet(Snippet.new(:body => nil)) }
  end

  def test_edit_snippet_link_for_admin
    @current_user = users(:laura)
    assert_match 'Edit', edit_snippet_link(Snippet.new)
  end
  
  def test_edit_snippet_link_participant
    @current_user = users(:ernest)
    assert_no_match /Edit/, edit_snippet_link(Snippet.new)
  end
  
  def test_navbar_should_restrict_expert_links
    @current_user = Expert.new
    expert_navbar = navbar
    assert_no_match /Metrics/,              expert_navbar
    assert_no_match /System/,               expert_navbar
    assert_no_match /Manage User Accounts/, expert_navbar
  end

  def test_show_notice_if_closed
    Settings.open = false
    assert_match 'The DialogSpace is Closed', show_notice_if_closed
  end

  def test_show_notice_if_closed_open
    Settings.open = true
    assert_nil show_notice_if_closed
  end
  
  def test_breadcrumb_links
    assert_nothing_raised {breadcrumb_links(nil)}
    assert_nothing_raised {breadcrumb_links([])}
  end
  
  def test_breadcrumb_links_creates_links
    output = breadcrumb_links([['home', '/'], 'Archives'])
    assert_match '<a href="/">home</a>', output
    assert_match 'Archives', output
  end
  
  # stand-in so we don't actually do any routing (originally defined in UniformLinkHelper)
  def add(*args); args[1] end

  def logged_in?
    @current_user    
  end
end
