require File.dirname(__FILE__) + '/../test_helper'

class SystemControllerTest < Test::Rails::ControllerTestCase

  fixtures :topics, :users, :settings, :support_materials, :readings

  # only admin can access the system controller
  def test_redirect_participant
    login_as :ernest # a participant
    get :index
    assert_response :redirect
  end

  def test_redirect_expert
    login_as :frank # an editor
    get :index
    assert_response :redirect
  end
  
  def test_permit_admin
    login_as :laura # an admin
    get :index
    assert_response :success
  end
  
  [:consultation_name, :consultation_description, :application_url, :admin_email, :no_reply_email, :email_subject_label].each do |setting|
    define_method("test_settings_#{setting}") do
      login_as :laura # an admin
      post :settings, {setting => 'cat'}
      assert_equal 'cat', Settings.send(setting), "#{setting} setting no set."
    end
  end
end
