require File.dirname(__FILE__) + '/../test_helper'

class MessagesControllerTest < Test::Rails::ControllerTestCase

  fixtures :users, :avatars, :topics, :readings
  
  def setup
    super
    login_as :laura
  end
  
  def test_send_topic_users
    post_send_topic_users
    assert_equal Topic.find(1).reading_participants.uniq.length, @deliveries.length
  end
  
  def test_send_topic_users_sets_flash
    post_send_topic_users
    assert_equal "Message sent to 1 users", flash[:notice]
  end
  
  def test_send_message
    assert_nothing_raised { send_message }
  end
  
  def test_send_message_sends_a_message
    send_message
    assert_equal 1, @deliveries.length
  end
  
  def test_send_message_sends_to_right_user
    send_message(:to_user => 2)
    assert_equal User.find(2).email, @deliveries[0].header['to'].to_s
  end
  
  def test_send_message_includes_message
    send_message(:message_body => 'yawza!')
    assert_match 'yawza!', @deliveries[0].body
  end
  
  def test_send_message_guest_cannot_send
    login_as :visitor1
    send_message
    assert_equal 0, @deliveries.length
  end
  
 private
  
  def post_send_topic_users
    post :send_topic_users, :id => 1, :message_subject => 'yawza!', :message_body => 'this and that'
  end
  
  def send_message(changes_hash={})
    get 'send_message', {:to_user => 1, :message_body => 'hey there'}.merge(changes_hash)    
  end
end
