class QueryHelper
  #
  #     QueryHelper.new(options, :base => ['ratings.value != 77'], :topic => 'comments.topic_id = ?', :age => 'ratings.created_on > ?')
  #
  def initialize(params, query_options)
    @conditions_query  = [query_options[:base] && query_options[:base][0] || '1']
    @conditions_values = [query_options[:base] && query_options[:base][1]].compact
    
    if params[:topic]
      @conditions_query << "#{query_options[:topic]} = ?"
      @conditions_values << params[:topic]
    end
    
    if params[:max_age]
      @conditions_query << "#{query_options[:age]} > ?"
      @conditions_values << params[:max_age].hours.ago
    end
    
    @sort_order = params[:reverse] ? 'ASC' : 'DESC'
  end
  
  def conditions
    [@conditions_query.join(' AND '), *@conditions_values]
  end
  
  def sort_order; @sort_order; end
end