CREATE TABLE `comments` (
  `id` int(11) NOT NULL auto_increment,
  `body` text,
  `created_by` int(11) default NULL,
  `created_at` datetime default NULL,
  `topic_id` int(11) default '0',
  `root_id` int(11) default '0',
  `parent_id` int(11) default '0',
  `lft` int(11) default '0',
  `rgt` int(11) default '0',
  `depth` int(11) default '0',
  `removed` tinyint(1) default '0',
  `word_count` int(11) default NULL,
  `reading_count` int(11) default '0',
  `avg_rating` float default NULL,
  PRIMARY KEY  (`id`),
  KEY `index_comments_on_created_by` (`created_by`),
  KEY `index_comments_on_topic_id` (`topic_id`),
  KEY `index_comments_on_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `comments_search_terms` (
  `comment_id` int(11) default NULL,
  `search_term_id` int(11) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `logged_exceptions` (
  `id` int(11) NOT NULL auto_increment,
  `exception_class` varchar(255) default NULL,
  `controller_name` varchar(255) default NULL,
  `action_name` varchar(255) default NULL,
  `message` varchar(255) default NULL,
  `backtrace` text,
  `environment` text,
  `request` text,
  `created_at` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `ratings` (
  `id` int(11) NOT NULL auto_increment,
  `value` int(11) NOT NULL default '0',
  `subject_id` int(11) NOT NULL default '0',
  `participant_id` int(11) default NULL,
  `created_on` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `index_ratings_on_participant_id` (`participant_id`),
  KEY `index_ratings_on_created_on` (`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `readings` (
  `id` int(11) NOT NULL auto_increment,
  `participant_id` int(11) NOT NULL default '0',
  `readable_id` int(11) default NULL,
  `created_at` datetime default NULL,
  `readable_type` varchar(255) default NULL,
  PRIMARY KEY  (`id`),
  KEY `index_readings_on_participant_id` (`participant_id`),
  KEY `index_readings_on_readable` (`readable_id`,`readable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `schema_info` (
  `version` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `search_terms` (
  `id` int(11) NOT NULL auto_increment,
  `term` varchar(255) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `sessions` (
  `id` int(11) NOT NULL auto_increment,
  `session_id` varchar(255) default NULL,
  `data` text,
  `updated_at` datetime default NULL,
  `created_at` datetime default NULL,
  PRIMARY KEY  (`id`),
  KEY `index_sessions_on_session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL auto_increment,
  `var` varchar(255) NOT NULL default '',
  `value` varchar(255) default NULL,
  `created_at` datetime default NULL,
  `updated_at` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `snippets` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `body` text,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `support_materials` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `url` varchar(255) default '',
  `topic_id` int(11) NOT NULL default '0',
  `filename` varchar(255) default NULL,
  `reading_count` int(11) default NULL,
  `content_type` varchar(255) default NULL,
  `size` int(11) default NULL,
  `parent_id` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `topics` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `introduction` text,
  `body_copy` text,
  `start_date` date default NULL,
  `expert_id` int(11) default NULL,
  `approved` blob,
  `continue_reading` varchar(255) default 'Read the full piece',
  `end_date` date NOT NULL default '0000-00-00',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `users` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(255) default NULL,
  `type` varchar(255) default NULL,
  `email` varchar(100) default NULL,
  `crypted_password` varchar(40) default NULL,
  `salt` varchar(40) default NULL,
  `created_at` datetime default NULL,
  `bio` text,
  `picture` varchar(255) default NULL,
  `user_number` varchar(255) default NULL,
  `year_of_birth` int(11) default NULL,
  `gender` int(11) default '0',
  `postal_code` varchar(255) default NULL,
  `login_key` varchar(255) default NULL,
  `verified` tinyint(1) default '0',
  `login_key_expires_at` datetime default NULL,
  `avg_rating` float default NULL,
  `suspended` tinyint(1) default '0',
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO schema_info (version) VALUES (40)