module ApplicationPolicy
  class << self
    def participation_enabled?
      Settings.open
    end
  
    def user_can_view_closed_application?(user)
      user && [:admin, :expert].include?(user.role)
    end
  
    def messaging_enabled?
      true
    end
  
    def show_support_material?
      true
    end
    
    def guests_allowed?
      true
    end
  
    def recording_user_numbers?
      false
    end
    
    def can_send_message_to?(sender, receiver)  # TODO test
      messaging_enabled? && sender.registered? && receiver.receive_messages_from_participants?
    end
  end
end
