class CommentObserver < ActiveRecord::Observer
  
  def after_create(comment)
    if comment.subject.is_a? Comment
      UserNotifier.deliver_reply_notification(comment.subject.user, comment)
    end
  end
  
  # called by CommentRatingObserver after_create and after_destroy
  def after_rating_change(comment)   
    comment.update_average_rating_cache      # update the comments avg_value
    comment.user.update_average_rating_cache # update the ratees average rating
  end
  
end
