# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  type                :string(255)   
#  value               :string(255)   
#

class WhitelistFilterItem < RegistrationFilterItem
  validates_format_of :value, :with => RFC822::EmailAddress
  
  # Return an array of matching RegisteredUsers
  def matching_users
    RegisteredUser.find(:all, :conditions => ['email = ?', value])
  end
  
  class << self
    def match?(email)
      find(:first, :conditions => ['value = ?', email])
    end
    
    def find_for_user(user)
      find(:all, :conditions => ["#{table_name}.value = ?", user.email])
    end
    
    def add_in_bulk(file)
      results = {:failed_saves => []}
      count_before = count
      file.each_line do |line|
        email = line.strip
        next if email.blank?
        item = create(:value => email)
        if item.new_record?
          results[:failed_saves] << item
        end
      end
      results[:new_items_count] = count - count_before
      return results
    end
  end
end
