class UserMessager < ActionMailer::Base
  # a message sent from one participant to another
  def user_message(from, to, message)
    recipients  to.email_address_with_name
    from        Settings.no_reply_email
    subject     "[%s] " % Settings.email_subject_label
    sent_on     Time.now
    body        :from => from, :to => to, :message => message, :consultation_name => Settings.consultation_name
    @subject   += "message from #{from.name}"
  end
end
