# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  value               :integer(11)   default(0), not null
#  subject_id          :integer(11)   default(0), not null
#  participant_id      :integer(11)   
#  created_on          :datetime      not null
#  type                :string(255)   
#

class TopicRating < AbstractRating
  belongs_to :subject, :class_name => 'Topic', :foreign_key => 'subject_id'
  # TODO validates value between 1-5
  
  def mapping # Agree (4), Somewhat Agree (3), Unsure (77) Somewhat Disagree (2) Disagree (1)
    # TODO these strings should be stored as application settings
    [ 
      [4,  'Agree'],
      [3,  'Somewhat Agree'], 
      [77, 'Unsure'],
      [2,  'Somewhat Disagree'],
      [1,  'Disagree']
    ]
  end
  
  class << self
    def report(topic_id=nil)
      topic_condition = "AND subject_id = #{topic_id}" if topic_id
      report_raw("SELECT #{selected_fields} FROM ratings WHERE #{type_restriction} #{topic_condition} ORDER BY created_on")
    end    
  end
end
