# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  value               :integer(11)   default(0), not null
#  subject_id          :integer(11)   default(0), not null
#  participant_id      :integer(11)   
#  created_on          :datetime      not null
#  type                :string(255)   
#

class MaterialConvincingRating < AbstractRating
  belongs_to :subject, :class_name => 'SupportMaterial', :foreign_key => 'subject_id'
  
  def mapping
    # TODO these strings should be stored as application settings
    [ 
      [1, 'Changes your opinion'], 
      [2, 'does not change your opinion']
    ]
  end
  
  class << self
    def report(topic_id=nil)
      if topic_id
        topic_condition = "AND support_materials.topic_id = #{topic_id}"
        report_raw("SELECT #{selected_fields} FROM ratings INNER JOIN support_materials ON ratings.subject_id = support_materials.id WHERE #{type_restriction} #{topic_condition} ORDER BY created_on")        
      else
        report_raw("SELECT #{selected_fields} FROM ratings WHERE #{type_restriction} ORDER BY created_on")
      end
    end    
  end
  
end
