# Schema as of Fri Jun 29 21:58:21 EDT 2007 (schema version 45)
#
#  id                  :integer(11)   not null
#  name                :string(255)   
#  type                :string(255)   
#  email               :string(100)   
#  crypted_password    :string(40)    
#  salt                :string(40)    
#  created_at          :datetime      
#  bio                 :text          
#  picture             :string(255)   
#  user_number         :string(255)   
#  year_of_birth       :integer(11)   
#  gender              :integer(11)   default(0)
#  postal_code         :string(255)   
#  login_key           :string(255)   
#  verified            :boolean(1)    
#  login_key_expires_at:datetime      
#  avg_rating          :float         
#  suspended           :boolean(1)    
#  receive_messages_fro:boolean(1)    default(true)
#

class Guest < User
  has_many :readings, :foreign_key => :participant_id, :dependent => :delete_all
  
  def handle
    'Guest'
  end

  def guest?
    true
  end
  
  # Remove all guest accounts that have not rated or read anything.
  def Guest.destroy_unused_accounts
    @dormant_ids = []
    Guest.find(:all).each do |g|
      # we don't check for Comments, since Guests cannot comment
      @dormant_ids << g.id if g.ratings.count == 0 && g.readings.count == 0
    end
    Guest.delete(@dormant_ids)
  end
  
end
